
//*****************************************************************************
//
// \file uart_drv.h
//
// \brief 
//
// Copyright (c) 2013-2014 Texas Instruments Incorporated.  All rights reserved.
// Software License Agreement
// 
// Texas Instruments (TI) is supplying this software for use solely and
// exclusively on TI's microcontroller products. The software is owned by
// TI and/or its suppliers, and is protected under applicable copyright
// laws. You may not combine this software with "viral" open-source
// software in order to form a larger program.
// 
// THIS SOFTWARE IS PROVIDED "AS IS" AND WITH ALL FAULTS.
// NO WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT
// NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. TI SHALL NOT, UNDER ANY
// CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
// DAMAGES, FOR ANY REASON WHATSOEVER.
// 
//*****************************************************************************
#ifndef UART_DRV_H
#define UART_DRV_H

// Types

typedef enum
{
	USCIA_0
//	USCIB_0,
} UART_PORT_SELECT;

// Defines

// UART Interrupt Settings
#define UART_RX               ((U8)0x00) // UART Rx Priority (UD0RIC)
#define UART_TX               ((U8)0x00) // UART Tx Priority (UD0TIC)
#define UART_SBF              ((U8)0x00) // UART SBF Priority (UD0SIC)
#define UART_DISABLE          ((U8)0x47) // UART Disable

// Macros
#define Disable_UART_RX( Port ) \
{\
   P1SEL  &= ~BIT1;\
   P1SEL2 &= ~BIT1;\
}

#define Enable_UART_RX(Port )  \
{\
	P1SEL  |= BIT1;\
	P1SEL2 |= BIT1;\
}

#define Disable_UART_RX_DormantMode( Port )  \
{\
  if (USCIA_0 == Port) \
  {\
	UCA0CTL1 &= ~UCDORM;\
  }\
  else\
  {\
  }\
}

#define Disable_UART_BF_RX_DormantMode( Port )  \
{\
  if (USCIA_0 == Port) \
  {\
	UCA0CTL1 &= ~(UCBRKIE + UCDORM);\
  }\
  else\
  {\
  }\
}

#define Enable_UART_RX_DormantMode( Port )  \
{\
  if (USCIA_0 == Port) \
  {\
	UCA0CTL1 |= UCDORM;\
  }\
  else\
  {\
  }\
}

#define Disable_UART_RX_Interrupt( Port )  \
{\
  if (USCIA_0 == Port) \
  {\
    IE2 &= ~UCA0RXIE;\
    UCA0CTL1 |= UCSWRST;\
  }\
  else\
  {\
  }\
}

#define Enable_UART_RX_Interrupt( Port )  \
{\
  if (USCIA_0 == Port) \
  {\
    UCA0CTL1 &= ~UCSWRST;\
    IE2 |= UCA0RXIE;\
  }\
  else\
  {\
  }\
}

// Disable break condition, reset USCI state machine, disable USCI_A0 RX interrupt
#define Disable_UART_BF_Interrupt( Port )  \
{\
  if (USCIA_0 == Port) \
  {\
    IE2 &= ~UCA0RXIE;\
    UCA0CTL1 |= UCSWRST;\
    UCA0CTL1 &= ~UCBRKIE;\
  }\
  else\
  {\
  }\
}

// Enable break condition, Initialize USCI state machine, Enable USCI_A0 RX interrupt
#define Enable_UART_BF_Interrupt( Port )  \
{\
  if (USCIA_0 == Port) \
  {\
    UCA0CTL1 |= UCBRKIE;\
    UCA0CTL1 &= ~UCSWRST;\
    IE2 |= UCA0RXIE;\
  }\
  else\
  {\
  }\
}

// Clear break flag
#define Clear_UART_BF_Flag( Port )  \
{\
  if (USCIA_0 == Port) \
  {\
	UCA0STAT &= ~UCBRK;\
  }\
  else\
  {\
  }\
}

// Read break flag
#define Read_UART_Flag(Port )  \
   (UCA0STAT & UCBRK)


// Export Variables
extern bool Sync_Byte_Received;

// Prototype Declarations
extern void UART_Init(UART_PORT_SELECT iPort);
extern void UART_Tx(UART_PORT_SELECT iPort, uint8_t Data);
extern uint8_t UART_Rx(UART_PORT_SELECT iPort);
#endif
